///
///	[FILENAME]	ADisound.js
///
///	Pre-installation completion utility "Modify Registry Tool for ADi Sound Driver" V1.00L10PM00
///		ADi Sound Driver : 6.10.1.6260 or later
///	(C)2008 Panasonic Corporation
///
///	Windows Scripting Host: JScript
///

var WindowsFolder = 0;

var vbDebug = false;
var vbOK = 0;
var L_MsgBox_Title_Text = "Modify Registry Tool for ADi Sound Driver";

var strRegBaseKey = "HKLM\\SYSTEM\\CurrentControlSet\\Control\\Class\\{4D36E96C-E325-11CE-BFC1-08002BE10318}\\";
var strRegDriverDescKey = "\\DriverDesc";
var strADi = "SoundMAX Integrated Digital HD Audio";

var strRegfileName = "ADisound.reg";
var strRegfileTop = "Windows Registry Editor Version 5.00";
var strRegfileBaseKey = "\[HKEY_LOCAL_MACHINE\\SYSTEM\\ControlSet001\\Control\\Class\\{4D36E96C-E325-11CE-BFC1-08002BE10318}\\";
var strRegfileSettingsKey = "\\PowerSettings\]";

var strPowerSavingItems = new Array (
	"\"PM_EAPD_MicMon\"=hex:01",
	"\"PM_EAPD_Mode\"=hex:01",
	"\"PM_EAPD_Polarity\"=hex:00",
	"\"PM_Last_Valid_Power_Mode_AC\"=hex:00",
	"\"PM_Last_Valid_Power_Mode_BATT\"=hex:00",
	"\"PM_Power_Mode\"=hex:00"
	);

var maxEntries = 100;

Main();
function Main()
{
	var WSHShell;
	var i, j;
	var strDriverDescKey;
	var strDriverDescVal;
	var fs;
	var regfile;

	var strSpecialFolder;
	var strRegeditFileName;

	/// Create Shell Obejct
	WSHShell = WScript.CreateObject("WScript.Shell");

	/// Create FileSystem Object
	fs = WScript.CreateObject("Scripting.FileSystemObject");

	/// check administrative privilege
	try
	{
		WSHShell.RegWrite("HKLM\\SOFTWARE\\Panasonic\\Dummy", "DummyData");
		WSHShell.RegDelete("HKLM\\SOFTWARE\\Panasonic\\Dummy");
	}
	catch (e)
	{
		WScript.Quit();
	}

	for (i = 0; i < maxEntries; i++) {
		// key of DriverDesc
		strDriverDescKey = strRegBaseKey + formatNum(4, i) + strRegDriverDescKey;
		// read DriverDesc from registry
		try
		{
			strDriverDescVal = WSHShell.RegRead(strDriverDescKey);
		}
		catch (e)
		{
			break;
		}
		if (vbDebug)
		{
			WSHShell.Popup("DriverDesc(" + i + ")= " + strDriverDescVal + "\n",
					0, L_MsgBox_Title_Text, vbOK );
		}
		// compare driverDesc
		if (strDriverDescVal == strADi) {
			// create reg file (overwrite)
			regfile = fs.CreateTextFile(strRegfileName, true);
			// write to reg file
			regfile.WriteLine(strRegfileTop);
			regfile.WriteBlankLines(1);
			regfile.WriteLine(strRegfileBaseKey + formatNum(4, i) + strRegfileSettingsKey);

			// PowerSaving settings
			for (j = 0; j < strPowerSavingItems.length; j++)
			{
				regfile.WriteLine(strPowerSavingItems[j]);
			}
			//@close reg file
			regfile.Close();
			// exit loop
			break;
		}
	}

	// execute reg file and delete it
	if (fs.FileExists(strRegfileName)) {
		// Windows root folder
		strSpecialFolder = fs.GetSpecialFolder(WindowsFolder);
		// full path of regedit.exe
		strRegeditFileName = strSpecialFolder + "\\regedit.exe";
		// execute regedit.exe
		if (fs.FileExists(strRegeditFileName)) {
			WSHShell.Run(strRegeditFileName + " /s " + strRegfileName, 0, true);
		}
		fs.DeleteFile(strRegfileName);
	}
}

// add 0 before number
function formatNum(keta, num) {
	var src = new String(num);
	var cnt = keta - src.length;
	if (cnt <= 0) return src;
	var str = new String;
	while (cnt-- > 0) str += "0";
	return (str + src);
}
